using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Results;
using System;
using System.Collections.Generic;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample to show how to get informations for the DiffGroups.
    /// Expects 2 arguments - the paths of the PDF files
    /// </summary>
    public class TypesOfDifferenceGroups
    {
        static TypesOfDifferenceGroups()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show the types of DiffGroups.
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            PDFComparer pdfComparer = new PDFComparer();

            using (ResultModel result = pdfComparer.Compare(args[0], args[1]))
            {
                List<DiffGroups> groups = result.GetDifferenceGroupsList(false);
                foreach(DiffGroups group in groups)
                {
                    System.Console.WriteLine("type of group = " + group.Type);
                }
            }
        }
    }

}